<?php
require_once 'admin/config.php';
require_login();

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $template_name = isset($_POST['template_name']) ? trim($_POST['template_name']) : '';
    $template_content = isset($_POST['template_content']) ? trim($_POST['template_content']) : '';

    if (empty($template_name) || empty($template_content)) {
        $error = 'Template name and content are required.';
    } elseif (preg_match('/[^a-zA-Z0-9_-]/', $template_name)) {
        $error = 'Template name can only contain letters, numbers, underscores, and dashes.';
    } else {
        $template_path = 'templates/' . $template_name . '.html';
        if (file_exists($template_path)) {
            $error = 'A template with this name already exists.';
        } else {
            if (file_put_contents($template_path, $template_content)) {
                $success = 'Template created successfully.';

                if (isset($_FILES['template_image']) && $_FILES['template_image']['error'] === UPLOAD_ERR_OK) {
                    $image_dir = 'assets/images/templates/';
                    $image_name = basename($_FILES['template_image']['name']);
                    $image_path = $image_dir . $image_name;
                    if (move_uploaded_file($_FILES['template_image']['tmp_name'], $image_path)) {
                        $success .= ' Image uploaded successfully.';
                    } else {
                        $error .= ' Failed to upload image.';
                    }
                }
                 header('Location: admin.php');
            } else {
                $error = 'Failed to create template file.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New Template</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/admin.css">
    <link rel="icon" type="image/jpeg" href="/assets/images/favicon.jpg">
</head>
<body>
<div class="wrapper">
    <!-- Sidebar -->
    <nav id="sidebar">
        <div class="sidebar-header">
            <h3>Admin Panel</h3>
        </div>

        <ul class="list-unstyled components">
            <li>
                <a href="admin.php">Templates</a>
            </li>
            <li>
                <a href="logout.php">Logout</a>
            </li>
        </ul>
    </nav>

    <!-- Page Content -->
    <div id="content">
        <h1 class="page-title">Add New Template</h1>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="template_name" class="form-label">Template Name (without .html extension)</label>
                        <input type="text" class="form-control" id="template_name" name="template_name" required>
                    </div>
                    <div class="mb-3">
                        <label for="template_content" class="form-label">Template Content (HTML)</label>
                        <textarea class="form-control" id="template_content" name="template_content" rows="10" required></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="template_image" class="form-label">Featured Image</label>
                        <input class="form-control" type="file" id="template_image" name="template_image">
                    </div>
                    <button type="submit" class="btn btn-primary">Create Template</button>
                    <a href="admin.php" class="btn btn-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>
</body>
</html>
