<?php
require_once 'admin/config.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Template Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/admin.css">
    <link rel="icon" href="/assets/images/favicon.jpg" type="image/jpeg">
</head>
<body>
<div class="wrapper">
    <!-- Sidebar -->
    <nav id="sidebar">
        <div class="sidebar-header">
            <h3>Admin Panel</h3>
        </div>

        <ul class="list-unstyled components">
            <li class="active">
                <a href="admin.php">Templates</a>
            </li>
            <li>
                <a href="logout.php">Logout</a>
            </li>
        </ul>
    </nav>

    <!-- Page Content -->
    <div id="content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="page-title">Template Management</h1>
            <a href="add_template.php" class="btn btn-primary btn-lg">Add New Template</a>
        </div>

        <div class="card">
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Template Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $templates = glob('templates/*.html');
                        if (!empty($templates)) {
                            foreach ($templates as $template) {
                                echo '<tr>';
                                echo '<td>' . htmlspecialchars(basename($template)) . '</td>';
                                echo '<td>';
                                echo '<a href="edit_template.php?template=' . urlencode(basename($template)) . '" class="btn btn-sm btn-outline-primary">Edit</a> ';
                                echo '<a href="delete_template.php?template=' . urlencode(basename($template)) . '" class="btn btn-sm btn-outline-danger" onclick="return confirm(\'Are you sure you want to delete this template?\')">Delete</a>';
                                echo '</td>';
                                echo '</tr>';
                            }
                        } else {
                            echo '<tr><td colspan="2">No templates found.</td></tr>';
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
</body>
</html>