<?php
declare(strict_types=1);
@ini_set('display_errors', '1');
@error_reporting(E_ALL);

require_once __DIR__ . '/../db/config.php';

try {
    $pdo = db();
    $stmt = $pdo->prepare("SELECT `id`, `filename` FROM `published_pages` WHERE `expires_at` < NOW()");
    $stmt->execute();
    $expired_pages = $stmt->fetchAll();

    $deleted_count = 0;
    foreach ($expired_pages as $page) {
        $filepath = __DIR__ . '/../published/' . $page['filename'];
        if (file_exists($filepath)) {
            unlink($filepath);
        }

        $delete_stmt = $pdo->prepare("DELETE FROM `published_pages` WHERE `id` = ?");
        $delete_stmt->execute([$page['id']]);
        $deleted_count++;
    }

    echo "Expired pages cleanup completed. $deleted_count pages deleted.\n";

} catch (PDOException $e) {
    error_log("DB Error: " . $e->getMessage());
    die("An error occurred during cleanup.\n");
}

