<?php
require_once 'admin/config.php';
require_login();

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $error = 'All fields are required.';
    } elseif (!password_verify($current_password, ADMIN_PASSWORD)) {
        $error = 'Incorrect current password.';
    } elseif ($new_password !== $confirm_password) {
        $error = 'New password and confirmation do not match.';
    } else {
        $config_file = 'admin/config.php';
        $config_content = file_get_contents($config_file);
        $new_hash = password_hash($new_password, PASSWORD_DEFAULT);
        $new_config_content = preg_replace(
            '/define\(\'ADMIN_PASSWORD\',\s*\'.*\'\);/',
            "define('ADMIN_PASSWORD', '" . $new_hash . "');",
            $config_content
        );

        if (file_put_contents($config_file, $new_config_content)) {
            $success = 'Password changed successfully.';
        } else {
            $error = 'Failed to update password. Please check file permissions.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Change Password - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/admin.css">
    <link rel="icon" href="/assets/images/favicon.jpg" type="image/jpeg">
</head>
<body>
<div class="wrapper">
    <!-- Sidebar -->
    <nav id="sidebar">
        <div class="sidebar-header">
            <h3>Admin Panel</h3>
        </div>

        <ul class="list-unstyled components">
            <li>
                <a href="admin.php">Templates</a>
            </li>
            <li>
                <a href="editor_13d84da0257b8680.php">Editor</a>
            </li>
            <li class="active">
                <a href="change_password.php">Change Password</a>
            </li>
            <li>
                <a href="edit_file.php?file=editor_13d84da0257b8680.php">Edit Editor Page</a>
            </li>
            <li>
                <a href="logout.php">Logout</a>
            </li>
        </ul>
    </nav>

    <!-- Page Content -->
    <div id="content">
        <h1 class="page-title">Change Password</h1>

        <div class="card">
            <div class="card-body">
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                <?php if ($success): ?>
                    <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>

                <form action="change_password.php" method="post">
                    <div class="mb-3">
                        <label for="current_password" class="form-label">Current Password</label>
                        <input type="password" class="form-control" id="current_password" name="current_password" required>
                    </div>
                    <div class="mb-3">
                        <label for="new_password" class="form-label">New Password</label>
                        <input type="password" class="form-control" id="new_password" name="new_password" required>
                    </div>
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Confirm New Password</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Change Password</button>
                </form>
            </div>
        </div>
    </div>
</div>
</body>
</html>