<?php
require_once 'admin/config.php';
require_login();

$error = '';
$success = '';

$template_name = isset($_GET['template']) ? basename($_GET['template']) : '';

if (empty($template_name)) {
    header('Location: admin.php');
    exit;
}

$template_path = 'templates/' . $template_name;

if (!file_exists($template_path)) {
    die('Template not found.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $template_content = isset($_POST['template_content']) ? trim($_POST['template_content']) : '';

    if (empty($template_content)) {
        $error = 'Template content is required.';
    } else {
        if (file_put_contents($template_path, $template_content)) {
            $success = 'Template updated successfully.';

            if (isset($_FILES['template_image']) && $_FILES['template_image']['error'] === UPLOAD_ERR_OK) {
                $image_dir = 'assets/images/templates/';
                $image_name = basename($_FILES['template_image']['name']);
                $image_path = $image_dir . $image_name;
                if (move_uploaded_file($_FILES['template_image']['tmp_name'], $image_path)) {
                    $success .= ' Image uploaded successfully.';
                } else {
                    $error .= ' Failed to upload image.';
                }
            }
             header('Location: admin.php');
        } else {
            $error = 'Failed to update template file.';
        }
    }
} else {
    $template_content = file_get_contents($template_path);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Template</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/admin.css">
    <link rel="icon" href="/assets/images/favicon.jpg" type="image/jpeg">
</head>
<body>
<div class="wrapper">
    <!-- Sidebar -->
    <nav id="sidebar">
        <div class="sidebar-header">
            <h3>Admin Panel</h3>
        </div>

        <ul class="list-unstyled components">
            <li>
                <a href="admin.php">Templates</a>
            </li>
            <li>
                <a href="logout.php">Logout</a>
            </li>
        </ul>
    </nav>

    <!-- Page Content -->
    <div id="content">
        <h1 class="page-title">Edit Template: <?php echo htmlspecialchars($template_name); ?></h1>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="template_content" class="form-label">Template Content (HTML)</label>
                        <textarea class="form-control" id="template_content" name="template_content" rows="10" required><?php echo htmlspecialchars($template_content); ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="template_image" class="form-label">Featured Image (optional, will replace existing)</label>
                        <input class="form-control" type="file" id="template_image" name="template_image">
                    </div>
                    <button type="submit" class="btn btn-primary">Update Template</button>
                    <a href="admin.php" class="btn btn-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>
</body>
</html>