<?php
declare(strict_types=1);
@ini_set('display_errors', '1');
@error_reporting(E_ALL);
@date_default_timezone_set('UTC');

// Read project preview data from environment
$projectDescription = $_SERVER['PROJECT_DESCRIPTION'] ?? 'Create and customize your own ebook landing page.';
$projectImageUrl = $_SERVER['PROJECT_IMAGE_URL'] ?? '';
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Landing Page</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="icon" href="/assets/images/favicon.jpg" type="image/jpeg">
    <link rel="stylesheet" href="assets/css/custom.css">
</head>
<body>

    <header class="py-3 mb-4 border-bottom bg-white">
        <div class="container d-flex flex-wrap justify-content-center">
            <a href="/" class="d-flex align-items-center mb-3 mb-md-0 me-md-auto text-dark text-decoration-none">
                <span class="fs-4">Contentrepreneur Quick Pages</span>
            </a>

        </div>
    </header>

    <main class="container">
        <div class="p-5 mb-4 bg-light rounded-3">
            <div class="container-fluid py-5">
                <h1 class="display-5 fw-bold">Create Beautiful Ebook Landing Pages in Minutes</h1>
                <p class="col-md-8 fs-4">Our powerful and easy-to-use page builder helps you create stunning landing pages for your ebooks. No coding required. Start building your page today!</p>
                <a href="https://www.thecontentrepreneur.com/e-book-builder?preview=true" class="btn btn-success btn-lg">Purchase Access</a>
            </div>
        </div>

        <div class="row align-items-md-stretch">
            <div class="col-md-6">
                <div class="h-100 p-5 text-white bg-dark rounded-3">
                    <h2>Feature-Rich Editor</h2>
                    <p>Choose from a variety of templates, customize your content, and see a live preview of your page as you build it. Our editor is designed to be intuitive and flexible.</p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="h-100 p-5 bg-light border rounded-3">
                    <h2>Publish with Ease</h2>
                    <p>Once your page is ready, you can download it as a ZIP file or publish it directly to a unique URL on our platform. Share your ebook with the world in just a few clicks.</p>
                </div>
            </div>
        </div>
    </main>

    <footer class="text-center py-3 mt-5 bg-light border-top">
        <p class="mb-0">&copy; <?= date('Y') ?> <a href="https://www.thecontentrepreneur.com/">The Contentrepreneur</a></p>
    </footer>

</body>
</html>